CREATE TABLE IF NOT EXISTS `sys_tenant_number_rule`
(
    `id`                 bigint(20) NOT NULL COMMENT '唯一ID',
    `sys_tenant_id`      bigint(20) NOT NULL COMMENT '租户ID',
    `sys_number_rule_id` bigint(20) NOT NULL COMMENT '发号器规则ID',
    `bind_time`          datetime     DEFAULT NULL COMMENT '绑定时间',
    `tenant_id`          bigint(20)   DEFAULT NULL COMMENT '租户ID',
    `remark`             varchar(255) DEFAULT NULL COMMENT '备注',
    `create_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录创建者ID',
    `creator`            varchar(255) DEFAULT NULL COMMENT '记录创建者',
    `create_time`        datetime     DEFAULT NULL COMMENT '记录创建时间',
    `modify_user_id`     bigint(20)   DEFAULT NULL COMMENT '记录最后更新者ID',
    `updater`            varchar(255) DEFAULT NULL COMMENT '记录最后更新者',
    `modify_time`        datetime     DEFAULT NULL COMMENT '记录最后更新时间',
    `delete_flag`        int(11)      DEFAULT '0' COMMENT '逻辑删除，0：未删除，1：已删除',
    `audit_data_version` int(11)      DEFAULT NULL COMMENT '版本',
    `sec_bu_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_bu_id',
    `sec_user_id`        bigint(20)   DEFAULT NULL COMMENT 'sec_user_id',
    `sec_ou_id`          bigint(20)   DEFAULT NULL COMMENT 'sec_ou_id',
    PRIMARY KEY (`id`),
    KEY `idx_tenant_number_tenant_id` (`sys_tenant_id`)
) COMMENT ='租户与发号器规则的绑定';